function SlideAs(effects, element, extra) {
    effects = effects.toLowerCase();

  var optionArray = [];
  var resetFollowing = false;
  var addClass;

    effectArray = effects.split(/\s+/);

    $each(effectArray, function (effect) {
      if (/^\s*$/.test(effect)) { return; }

      switch ( effect.match(/^([\w\d]+)/)[1] ) {
      case 'show':            $show(element); break;
      case 'resetfollowing':  resetFollowing = true;
      case 'hidewhendone':    break;
      case 'class':           addClass = [effect.substr(6), effect.charAt(5) == '+'];

      default:
        var options = ShallowCopyOf(extra);

          options.element = element;
          options.prop = effect;

        if (resetFollowing) { SlidePropValueOf(element, effect, 0); }

        optionArray.push(options);
      }
    });

  if (IsNonEmptyArray(optionArray)) {
    optionArray[0].onDone = AddChainFuncTo(optionArray[0].onDone, function () {
      if (effects.indexOf('hidewhendone') != -1) {
        $hide(element);
      }
      if (addClass) { ModifyClassNameOf( element, addClass[0], addClass[1] ); }
    });

    return Slide(optionArray);
  }
}

// options.accel = 0|2+ - values > 2 will finish earlier than maxDuration.
// Make sure that updInterval of all options are the same.
function Slide(optionArray) {
  if (!IsNum(optionArray.length)) { optionArray = [optionArray]; }

  $each(optionArray, function (options) {
    options.element = $(options.element);
      if (!DebugAssert(options.element)) { options.element = null; return; }

    SetupSlideOptions(options);
    $show(options.element);

    if (IsFunc(options.onStart)) {
      options.onStart.call(this, options);
    }
  });

  SlideTimer(optionArray);
}

  function SetupSlideOptions(options) {
    if (!DebugAssert(options.element && IsNum(options.maxDuration))) {
      return;
    }

    options.prop = (options.prop || 'height').toLowerCase();
    options.curValue = SlidePropValueOf(options.element, options.prop);

    options.reverse = options.reverse == true ? true : false;
    options.accel = options.accel == true ? 2
                    : (IsNum(options.accel) ? options.accel : 0);

    options.startTime = Microtime();
      options.endTime = Microtime() + options.maxDuration;

    if (!IsNum(options.updInterval)) {
      options.updInterval = options.maxDuration > 100 ? 20 : 10;
    }

    options.onSlide = IsFunc(options.onSlide) ? options.onSlide : new Function();
    options.onDone  = IsFunc(options.onDone)  ? options.onDone  : new Function();

    if (!IsNum(options.targetValue)) {
      options.targetValue = DefaultTargetValueFor(options);
    }

    if (options.accel != 0) {
      options.incBy = Math.abs(options.targetValue - options.curValue)
                      * options.updInterval / options.maxDuration;
    }
  }

function SlideTimer(optionArray) {
  var oneDone = false;

  $each(optionArray, function (options) {
    var curValueRound = Math.round(options.curValue);

      var limitReached = options.reverse ? curValueRound <= 0
                                         : curValueRound >= options.targetValue;

    curValueRound = !limitReached && CalcIncBy(options);

      var done = !IsNum(curValueRound);
      oneDone |= done;

    if (!oneDone) {
      SlidePropValueOf( options.element, options.prop, curValueRound );
      options.onSlide.call(this, optionArray);
    }
  });

  if (oneDone) {
    $each(optionArray, function (options) {
      SlidePropValueOf( options.element, options.prop, options.targetValue );
      options.onDone.call(this, options);
    });
  } else {
    setTimeout(function () { SlideTimer(optionArray); }, optionArray[0].updInterval);
  }
}

function CalcIncBy(options) {
  var timeLeft = options.endTime - Microtime();
    if (timeLeft <= 0) { return null; }

  if (options.accel == 0) {
    var accelRatio = 1;

      var limit = Math.abs(options.curValue - options.targetValue);
    var incBy = limit * options.updInterval / timeLeft;
  } else {
    var accelRatio = options.accel * ((Microtime() - options.startTime)
                                      / (options.endTime - options.startTime));
    var incBy = options.incBy;
  }

  incBy = incBy * accelRatio * (options.reverse ? -1 : +1);

  options.curValue = Math.max(0, options.curValue + incBy);
    if (!options.reverse) {
      options.curValue = Math.min(options.targetValue, options.curValue);
    }

  return options.curValue;
}

  function SlidePropValueOf(elem, prop, newValue) {
    var value;

      switch (prop) {
      case 'height':    value = HeightOf(elem, newValue); break;
        case 'width':   value = WidthOf(elem, newValue); break;
      case 'top':  case 'left':
          newValue = IsNum(newValue) ? Math.round(newValue) + 'px' : null;
        value = $style(elem, prop, newValue);
        break;
      case 'opacity':   value = $opacity(elem, newValue); break;
      }

    return parseFloat(value);
  }

  function DefaultTargetValueFor(options) {
    if (!options.reverse) {
      switch (options.prop) {
      case 'height':    return ExpandedHeightOf(options.element);
      case 'opacity':   return 100;
      }
    }

    return 0;
  }
